#include "g_local.h"
#include "m_player.h"

void safebag_touch1( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0, rnd;

	if (!other->client)
		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))
	{
		return;
	}
	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > (int)(50.0 * (1.0 + (0.5*(other->client->pers.team == self->style)))))
		{
			// let them go away on their own terms
			T_Damage( other, other, other, vec3_origin, other->s.origin, vec3_origin, 9999, 0, 0, MOD_SAFECAMPER );
			last_touch_count = 0;
		}
	}

	last_touch_ent = other;

	if (self->timestamp > (level.time - 1.0))
		return;

	self->timestamp = level.time;

	// depositing, or withdrawing?

	if (other->client->pers.team == self->style)
	{	// deposit
		
		if (other->client->pers.currentcash > 0 || other->client->pers.bagcash > 0)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] += other->client->pers.currentcash;
			team_cash[self->style] += other->client->pers.bagcash;
			//UPDATESCORE

			other->client->resp.deposited += other->client->pers.currentcash;
			other->client->resp.deposited += other->client->pers.bagcash;

			other->client->pers.currentcash = 0;
			other->client->pers.bagcash = 0;

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

               rnd = (rnd + 1) % 12;

               switch(rnd)
               {
				case 0:
			    // make a droping sound
			    gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/hiredguy/fingers2.wav"), 1, 1, 0);
			    break;
				case 1:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/weapon7.wav"), 1, 1, 0);
				break;
                case 2:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/great.wav"), 1, 1, 0);
				break;
         
				case 3:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle4.wav"), 1, 1, 0);
			    break;
                
				case 4:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/actors/male/lenny/thanks2.wav"), 1, 1, 0);
			    break;

                case 5:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/scalper/yes1.wav"), 1, 1, 0);
			    break;

                case 6:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle2.wav"), 1, 1, 0);
			    break;
                
				case 7:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                
				case 8:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/iamback.wav"), 1, 1, 0);
			    break;
                case 9:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, 1, 0);
			    break;
                case 10:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle5.wav"), 1, 1, 0);
			    break;
                case 11:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/sold2.wav"), 1, 1, 0);
			    break;
				default:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
				}
			
			// let everyone know how much was deposited
    		amount = team_cash[self->style] - precash;
			safe_bprintf( PRINT_MEDIUM, "%s deposited $%i\n", other->client->pers.netname, amount );
			last_safe_deposit[self->style] = level.time;
		}

	}
	else if (team_cash[self->style] > 0)
	{	// withdrawal

		if (other->client->pers.bagcash < MAX_BAGCASH_PLAYER)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] -= (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);
			other->client->pers.bagcash += (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);

			if (team_cash[self->style] < 0)
			{	// don't take more than they have
				other->client->pers.bagcash += team_cash[self->style];
				team_cash[self->style] = 0;
			}
//			UPDATESCORE

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

			// alarm!
//			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("misc/cashmatch_alarm.wav"), 1, 1, 0);
			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, snd_fry1 , 1, 1, 0);

			// let everyone know how much was stolen
			amount = precash - team_cash[self->style];
			safe_bprintf( PRINT_MEDIUM, "%s stole $%i from %s's safe!\n", other->client->pers.netname, amount, team_names[self->style] );
			last_safe_withdrawal[self->style] = level.time;

			other->client->resp.acchit+=amount;
		}

	}
}


void safebag_touch2( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0, rnd;
	
	if (!other->client)
		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))
	{
		return;
	}
	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > (int)(50.0 * (1.0 + (0.5*(other->client->pers.team == self->style)))))
		{
			// let them go away on their own terms
			T_Damage( other, other, other, vec3_origin, other->s.origin, vec3_origin, 9999, 0, 0, MOD_SAFECAMPER );
			last_touch_count = 0;
		}
	}

	last_touch_ent = other;

	if (self->timestamp > (level.time - 1.0))
		return;

	self->timestamp = level.time;

	// depositing, or withdrawing?

	if (other->client->pers.team == self->style)
	{	// deposit
		
		if (other->client->pers.currentcash > 0 || other->client->pers.bagcash > 0)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] += other->client->pers.currentcash;
			team_cash[self->style] += other->client->pers.bagcash;
//			UPDATESCORE

			other->client->resp.deposited += other->client->pers.currentcash;
			other->client->resp.deposited += other->client->pers.bagcash;

			other->client->pers.currentcash = 0;
			other->client->pers.bagcash = 0;

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

	    		
               rnd = (rnd + 1) % 12;

               switch(rnd)
               {
				case 0:
			    // make a droping sound
			    gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/hiredguy/fingers2.wav"), 1, 1, 0);
			    break;
				
				case 1:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/weapon7.wav"), 1, 1, 0);
				break;

                case 2:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/great.wav"), 1, 1, 0);
				break;
                
				case 3:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle4.wav"), 1, 1, 0);
			    break;
                
				case 4:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/actors/male/lenny/thanks2.wav"), 1, 1, 0);
			    break;

                case 5:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/scalper/yes1.wav"), 1, 1, 0);
			    break;

                case 6:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle2.wav"), 1, 1, 0);
			    break;
                
				case 7:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                
				case 8:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/iamback.wav"), 1, 1, 0);
			    break;
                case 9:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, 1, 0);
			    break;
                case 10:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/lenny/idle5.wav"), 1, 1, 0);
			    break;
                case 11:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("world/pawnomatic/sold2.wav"), 1, 1, 0);
			    break;
				default:
    			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("actors/male/momo/idle4.wav"), 1, 1, 0);
			    break;
                }


			// let everyone know how much was deposited
			amount = team_cash[self->style] - precash;
			safe_bprintf( PRINT_MEDIUM, "%s deposited $%i\n", other->client->pers.netname, amount );
			last_safe_deposit[self->style] = level.time;
		}

	}
	else if (team_cash[self->style] > 0)
	{	// withdrawal

		if (other->client->pers.bagcash < MAX_BAGCASH_PLAYER)
		{
			int	precash, amount;

			precash = team_cash[self->style];

			team_cash[self->style] -= (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);
			other->client->pers.bagcash += (MAX_BAGCASH_PLAYER - other->client->pers.bagcash);

			if (team_cash[self->style] < 0)
			{	// don't take more than they have
				other->client->pers.bagcash += team_cash[self->style];
				team_cash[self->style] = 0;
			}
//			UPDATESCORE

			gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

			// alarm!
//			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("misc/cashmatch_alarm.wav"), 1, 1, 0);
			gi.positioned_sound(self->s.origin, self, CHAN_ITEM, snd_fry2 , 1, 1, 0);
            //EF_IONRIPPER; //EF_ROCKET; //EF_TRAP; //EF_FLAMETHROWER; //EF_FLIES; //EF_QUAD; //EF_BFG; //EF_HYPERBLASTER; // I changed this to make it look better //ghost
			// let everyone know how much was stolen
			amount = precash - team_cash[self->style];
			safe_bprintf( PRINT_MEDIUM, "%s stole $%i from %s's safe!\n", other->client->pers.netname, amount, team_names[self->style] );

			last_safe_withdrawal[self->style] = level.time;

			other->client->resp.acchit+=amount;
		}

	}
}



void SP_dm_safebag1(edict_t *ent)
{

   if (teamplay->value != 1)
   {
		G_FreeEdict (ent);
		return;
   }

    ent->classname = "dm_safebag1";
	ent->takedamage = DAMAGE_NO;


    ent->s.effects = EF_FLAG1;	
	
	ent->s.renderfx2 = RF2_NOSHADOW;
	ent->s.renderfx = RF_GLOW;

	
	if (!ent->style)
     ent->style = 1;

	if (ent->style < 1 || ent->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(ent->s.origin));
		G_FreeEdict(ent);
		return;
	}

	ent->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( ent->mins, -12, -12, -16 );
	VectorSet( ent->maxs,  12,  12,  12 );

    ent->movetype = MOVETYPE_BOUNCE;  
	ent->solid = SOLID_TRIGGER;

	gi.linkentity(ent);

	ent->touch = safebag_touch1;
	ent->currentcash = 0;	// start with no cash

	ent->think = safebag_think;
	ent->nextthink = level.time + 2;
}


void SP_dm_safebag2(edict_t *ent)
{

   if (teamplay->value != 1)
   {
		G_FreeEdict (ent);
		return;
   }

    ent->classname = "dm_safebag2";
    ent->takedamage = DAMAGE_NO;    

    ent->s.effects = EF_FLAG2;	
	

	ent->s.renderfx2 = RF2_NOSHADOW;
	ent->s.renderfx = RF_GLOW;

	
	if (!ent->style)
     ent->style = 2;

	if (ent->style < 1 || ent->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(ent->s.origin));
		G_FreeEdict(ent);
		return;
	}

	ent->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( ent->mins, -12, -12, -16 );
	VectorSet( ent->maxs,  12,  12,  12 );

    ent->movetype = MOVETYPE_BOUNCE;  
	ent->solid = SOLID_TRIGGER;

	gi.linkentity(ent);

	ent->touch = safebag_touch2;
	ent->currentcash = 0;	// start with no cash

	ent->think = safebag_think;
	ent->nextthink = level.time + 2;
}
